import java.util.*;
import java.io.*;
//******************************************************
// CLASS: index
//******************************************************
// This class handles hashing the policy dsicion tables
// it sorts the indexes from configuration file
//******************************************************

class index 
{
	Hashtable indexes;
	int max_index;
	int max_element;
	DataInputStream input;  
	
	public index(String file)
		{
			try 
			{
				System.out.println( "start indexing.."+file+"\n");
				input = new DataInputStream( new FileInputStream(file) );
				indexes = new Hashtable();
				String line;
				
				while ( (line = input.readLine()) != null) 
					{
						//System.out.println( "read line"+line);
						StringTokenizer t = new StringTokenizer(line," ");
						String name = t.nextToken();
						//System.out.println( "name"+name);
						String index = t.nextToken();
						//System.out.println( "index"+index);
						indexes.put( name, index );
						max_element++;
						int i = Integer.parseInt(index);
						max_index =  (i > max_index) ? i : max_index;
					}
					System.out.println( "stop indexing.."+file+"\n");
			}
			catch  ( IOException e )
		  {
				System.err.println( "File exception\n" + e.toString() );
			}
		}	
		
	public int get(String name) 
	{ 
		String sindex;
		if ( name == String.valueOf("") )
			return 0;	
		if ( (sindex = (String)indexes.get(name)) != null ) {
			//System.out.println("sindex"+sindex);
			return Integer.parseInt(sindex);
		}
		return -1;
	}			
}	
	