import java.util.*;
import java.io.*;

//******************************************************
// CLASS: randnum
//******************************************************
// This class handles interfacing with the Random class
// It makes a clean interface for rolling dice.
//
//******************************************************
class randnum
{
    Random r;

    public randnum()
    {
        //app = a;
        r = new Random();
    }

	//******************************************************
	// METHOD: NdM
	//******************************************************
	// Roll a "m" sided die, "n" times and return the sum. 
	//
	//******************************************************
	public int[] NdM(int n, int m)
    {
        int vals[] = new int[n];
        for (int i = 0; i < n; i++)
            vals[i] = dM(m);
        return vals;
    }
    
	//******************************************************
	// METHOD:  dM
	//******************************************************
	// Roll a "m" sided die and return the result.         
	//
	//******************************************************
    public int dM(int m)
    {
        return ((int)((r.nextDouble() * m) + 1.0));
    }

	//******************************************************
	// METHOD: d6
	//******************************************************
	// Roll the 6 die and return the results.. 
	//
	//******************************************************
    public int d6()
    {
        return dM(6);
    }    
}