// Externs.h
// This file contains all handles, etc that are shared between
// source modules. Include it in everything except tank.c where the
// variables are actually defined


// Tank and Robot positon in the world
extern struct _POSITION tankPos;
extern struct _POSITION robotPos;
extern struct _POSITION *pObject;

// External handles to all the windows, palettes, etc.
extern HWND     hCompassWnd;
extern HWND     hCenterWnd;
extern HWND	    hRadarWnd;
extern HWND		hViewWnd;
extern HWND     hMainWnd;
extern HPALETTE hPalette;

// Other shared variables
extern double	PI;
extern BOOL bTank;

/////////////////////////
// Functions declared in other source files
BOOL InitWorld(void);	// Defined in initworld.c
void RandomizePositions(void);	// Defined in RenderWorld.c
void RenderWorld(void);	// Defined in RenderWorld.c
void DrawPiller(void);	// Defined in RenderWorld.c
void DrawPyramid(void);	// Defined in RenderWorld.c
void DrawSlab(void);	// Defined in RenderWorld.c
void DrawWheel(void);	// Defined in RenderWorld.c