
// glutils.h
// General utility functions

// Convert Radians to Degrees
#define dRadToDeg(x) (((float)x)*57.29577951308f)



// Internal data structures
struct _POSITION
	{
	GLfloat xPos;				// X position on world grid
	GLfloat zPos;				// Z position on world grid
	GLdouble radsFromEast;      // Orientation from direct line east
	};

#define glRGB(x, y, z)	glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

// Not defined by Borland's headers, but found in SDK
const GLubyte* APIENTRY gluGetString (GLenum name);
#define GLU_VERSION             100800
#define GLU_EXTENSIONS          100801


// Generic OpenGL helpers
void ReduceToUnit(float vector[3]);
void calcNormal(float v[3][3], float out[3]);

// Windows Specific helpers
HPALETTE GetOpenGLPalette(HDC hDC);
void SetDCPixelFormat(HDC hDC);
void SetDCDepthPixelFormat(HDC hDC);

// Tank specific helpers
BOOL InitWorld(void);
void MoveViewer(GLdouble dStep);