// InitWorld.c
// This file contains the code to initialize the cyber-world

#include <windows.h>	// Normal Windows stuff
#include <gl\gl.h>
#include <gl\glu.h>
#include "glutils.h"
#include "externs.h"	// Data shared between files



///////////////////////////////////////////////////////////////////////////////
// Initialize the world and the objects in it.
BOOL InitWorld(void)
	{
	// Initialize position of the tank
	tankPos.xPos = 0.0f;
	tankPos.zPos = 0.0f;
	tankPos.radsFromEast = PI/2.0;	// Facing due north

	// Initialize the position of the robot
	robotPos.xPos = -300.0f;
	robotPos.zPos = -300.0f;

	robotPos.radsFromEast = 0.0;	// Facing due east
	
	// Set global object pointer to point at current vehicle
	// bTank is set in tank.c and specifies that the tank is the initial
	// viewer.
	if(bTank)
		pObject = &tankPos;
	else
		pObject = &robotPos;


	// Randomly place objects in scene
	RandomizePositions();

	return TRUE;
	}


