// CenterWnd.c
// This file contains the window procedure and code related to the
// window in the upper center of the main window. This window just
// displays movement instructions

#include <windows.h>	// Normal Windows stuff
#include <gl\gl.h>		// OpenGL
#include <gl\glu.h>		// OpenGL utility library
#include "externs.h"	// Data shared between files


////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
// Window procedure, handles all messages for this window
LRESULT CALLBACK WndProcCenter(HWND    hWnd,
							UINT    message,
							WPARAM  wParam,
							LPARAM  lParam)
	{
	switch (message)
		{
		// This window will hardly ever be updated, or even invalidated
		case WM_PAINT:
			{	
			PAINTSTRUCT ps;
			char cWorkspace[64];	// String workspace
			RECT	rect;			// Dimensions of the window
			int iCurrRow = 0;		// Text Row (in pixels)

			BeginPaint(hWnd,&ps);
			
			// Get the dimensions of the window
			GetClientRect(hWnd, &rect);

			// Display the instructions title
			strcpy(cWorkspace,"** INSTRUCTIONS **");
			iCurrRow = DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_TOP);

			// Double space down
			iCurrRow *=2;
			rect.top = iCurrRow;
			strcpy(cWorkspace,"<- Left Arrow to Turn Left");
			iCurrRow += DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_TOP);

			rect.top = iCurrRow;
			strcpy(cWorkspace,"-> Right Arrow to Turn Right");
			iCurrRow += (DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_TOP)*2);

			// Up and down arrow instructions
			rect.top = iCurrRow;
			strcpy(cWorkspace,"/\\ Up Arrow to Move Forward");
			iCurrRow += DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_TOP);

			rect.top = iCurrRow;
			strcpy(cWorkspace,"\\/ Down Arrow to Move Back");
			iCurrRow += DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_TOP);

			// Put at bottom of rectangle
			strcpy(cWorkspace,"(c) Copyright, 1996 Waite Group Press");
			DrawText(ps.hdc,cWorkspace,strlen(cWorkspace),&rect, DT_CENTER | DT_BOTTOM | DT_SINGLELINE);

			EndPaint(hWnd, &ps);
			}
			
		default:   // Passes it on if unproccessed
		    return (DefWindowProc(hWnd, message, wParam, lParam));

		}

    return (0L);
	}


