% Copyright 2010 Guy Baruch

% For parameters given in W, calculate (and add to W) the solution 
%   to the nonlinear S ODE using the modified "SLSR"
% see README file for details
%
function W = calc_S(W) 

    W = calc_S_L(W);

    condest(W.L)

    W.rhos = W.rhos';
    % IC
    S = exp(-W.rhos.^2);

    MAX_ITER=99;
    iter = 0;
    err = 1;
    tol = 1e-8
    
    while (err>tol && iter<MAX_ITER)
        iter = iter+1;
        S1 = S;
        cSr = (S.*(W.rhos.^(W.d-1)))';

        Kerr = ( (S.*conj(S)).^W.sigma ).*S;
        LK = W.L\Kerr ;
        coef = (cSr * S) / abs(cSr * LK);
        coef = (coef).^(1+0.5/W.sigma);
        S = coef * LK ;
        S0 = (9*S(1)-S(2))/8;
        S = S / (S0/abs(S0));
        err = max(abs(S-S1));

        disp([iter err abs(S0) max(abs(S)) ])
    end
    
    W.S = S;
    
end % calc_S

