% Copyright 2010 Guy Baruch

% For parameters given in W, calculate (and add to W):
%   1) grid spacing h_r
%   2) grid (rhos) 
%   3) the linear operator L
% see README file for details
%
function W = calc_S_L(W)

    M = W.M;    Rmax = W.Rmax;    d = W.d; 

	W.h_r = Rmax/M;

	rhos1 = (1:M)-1/2;
	W.rhos = rhos1*W.h_r;

	% stencil half width, e.g., =2 for 5pts stencil (second order)
	shw = 1 + W.order/2;

	M1 = M+2*shw;

	switch (W.order) 
		case 2
			
			sd1 = single_derivative( [1 -8 0 8 -1]/12);
			sd2 = single_derivative( [-1 16 -30 16 -1]/12);
			sd3 = single_derivative( [-1 2 0 -2 1]/2);
			sd4 = single_derivative( [1 -4 6 -4 1]);

			ra = [1 1];

			C0 = [ 0 1 ; 1 0 ];
            C1 = calc_L_C();

		case 4
			
			sd1 = single_derivative( [-1 9 -45 0 45 -9 1]/60);
			sd2 = single_derivative( [ 2 -27 270 -490 270 -27 2 ]/180);
			sd3 = single_derivative( [1 -8 13 0 -13 8 -1]/8 );
			sd4 = single_derivative( [-1 12 -39 56 -39 12 -1]/6 );

			ra = [ 1 1 1];

			C0 = [ 0 0 1 ; 0 1 0 ; 1 0 0 ];
            C1 = calc_L_C();

		otherwise 
			error('only second and fourth order implemented')
	end; % switch (order)

	%rhos2 = [ ra rhos1 ra ].';
	rhos2 = ( (1-shw:M+shw)-1/2).';

	BL1 = ...
		- (d-1)*(d-3) * spdiags(rhos2.^-3, 0,M1,M1)*sd1 ...
		+ (d-1)*(d-3) * spdiags(rhos2.^-2, 0,M1,M1)*sd2 ...
		+ 2*(d-1) * spdiags(rhos2.^-1, 0,M1,M1)*sd3 ...
		+ sd4;

	BL1 = BL1/W.h_r^4;


    k4 = W.kappa^4;
    BL1 = -BL1 ...  % negative bilaplacian
        + j*k4/4*spdiags(rhos2, 0,M1,M1)*sd1 ...    % i/4 rho*S' term
        + speye(M1) * ( -W.nu + j*k4/(2*W.sigma) );          % S terms

	% BL1 is a n+6 \times n+6 matrix, should splice BL and BL ghost

	% interior points
	L = BL1( shw+1:shw+M,shw+1:shw+M );

	% ghosts at axis -> symmetric BC
	L_ghost0 = BL1( shw+1:2*shw, 1:shw);
	inds = 1:shw;
	L(inds,inds) = L(inds,inds) + L_ghost0 * C0;

	% ghosts at outer boundary 
    if (2==W.order)
	    L_ghost1 = BL1( M+1:M+shw, M+shw+1:M1);
	    inds = M-shw+1:M;
	    L(inds,inds) = L(inds,inds) + L_ghost1 * C1;
    else
	    L_ghost1 = BL1( M+1:M+shw , M+shw+1:M1);
	    inds = M-1:M;
	    L(M-2:M,M-1:M) = L(M-2:M,M-1:M) + L_ghost1 * C1;
    end

    W.L = L;

	function sd = single_derivative(stencil)
		sd = spdiags( ones(M1,1)*stencil, -shw:shw, M1, M1 );
	end; % function single_derivative

    
    function C = calc_L_C()
        if 2==W.order
            indies = 3:4;
        else
            indies = 3:5;
        end
        rs = ((M-1:M+shw)-0.5)*W.h_r;  
        rs = rs';
        S = [...
                calc_S_lin_soln(W, rs, 0) ...
                calc_S_lin_soln(W, rs, 2) ...
            ];
%        f = [1 -4 6 -4 1]';
%        S = [ calc_S_lin_soln(2, d,sigma,kappa, rs, 0) f ];
        C = S(indies,:) / S(1:2,:);
    end; % function calc_L_C

end % calc_S_L

