% Copyright 2010 Guy Baruch

% Calculate WKB expansion of the S equation, for parameters in W
% see README for details
%
function y = calc_S_lin_soln(W, rhos, ind) 
    k4 = W.kappa^4;
    if (0==ind)
        y = rhos.^( -2/W.sigma - 4*j*W.nu/k4 );

    elseif (ind<4)
        G = 3/4^(4/3);
        alpha = exp( j*pi*(4*ind-3)/6 )
        powCoef = (W.sigma*W.d-1)/(1.5*W.sigma);

        ks1 = G*alpha*(rhos*W.kappa).^(4/3);
        ks2 = j*log(rhos)*4*W.nu/(3*k4);

        y = exp(ks1).*exp(ks2)./(rhos.^powCoef);
    else
        error('ind neq 0,1,2,3');
    end;
end % calc_S_lin_soln

