% Copyright 2010 Guy Baruch

% For paremeters given in W, create and plot the 4 WKB solutions to ths S
%   equation, their residual and the residual/solution ratio

W = create_W();

W  = calc_S_L(W);
condest(W.L)

rhos = W.rhos;

close all;
figure(1)
for ind=0:3
    subplot(2,2,ind+1);
    S = calc_S_lin_soln(W, rhos', ind);
    semilogy(rhos,abs(S),'k-')
    hold on
    semilogy(rhos,abs(W.L*S),'r')
    semilogy(rhos,abs(W.L*S)./abs(S),'b')
    %xlim([20,R])
    legend('S', 'L[S]', 'ratio')
    title(num2str(ind))
%    semilogy(rhos,abs(L*S)./abs(S),'b')
end

