%load cluster data
load cluster_data

%display men (first 10 rows)
scatter(data(1:10,1),data(1:10,2),'b.');
xlabel('height'), ylabel('weight')
hold on

%display women (last 10 rows)
scatter(data(11:20,1),data(11:20,2),'r.');
legend('men','women', 'Location', 'Northwest');

%cluster data into two clusters
[idx, C] = kmeans(data,2); 

%display cluster 1 as squares
scatter(data(idx==1,1),data(idx==1,2),'ks');
%display cluster 2 as circles
scatter(data(idx==2,1),data(idx==2,2),'ko');

%display cluster centroid data
fprintf('1st cluster centroid height %g and weight %g \n', C(1,1), C(1,2));
fprintf('2st cluster centroid height %g and weight %g \n', C(2,1), C(2,2));

%plot cluster centroids
plot(C(:,1), C(:,2), 'm*', 'MarkerSize', 10);

hold off