function [intersectX] = my_plot...
    (bac1_T,bac2_T, bac1_ip, bac2_ip, experiment_T, max_y)
%plots bacterial growth
%example: my_plot(30,45,1,4,240,250)
%inputs:
%bac1_T 1st bacteria binary fission cycle time in minutes
%bac2_T 2nd bacteria binary fission cycle time in minutes
%bac1_ip 1st bacteria initial population
%bac2_ip 2nd bacteria initial population
%experiment_T experiment time in minutes (e.g. %40 minutes = 4 hours)
%max_y = y limit for the plot
%output:
%intersectX the time in minutes the two population intersect

X=1:experiment_T;  %time vector

%calculate y values:  ip * 2 ^(t/T) 
%where ip is inital population, t is time and T is the binary fission cycle time
bac1_y=bac1_ip.*2.^(X./bac1_T);
bac2_y=bac2_ip.*2.^(X./bac2_T);

%at which times do the data meet?
intersectX_logicals=bac1_y==bac2_y;
%what is the value at that point
intersectY=bac1_y(intersectX_logicals);
%convert logical to indices
intersectX=find(intersectX_logicals);

%first subplot
subplot(2,1,1)
%plot
plot(X,bac1_y, X, bac2_y)

%fancy stuff
title('Bacterial growth as a function of time');
ylabel('Bacterial Count');
legend('bac1', 'bac2','Location', 'NorthWest');
%limit axis
axis([1,experiment_T,0,max_y]);
%plot intersection point
hold on
plot(intersectX,intersectY,'r*');

%second subplot
subplot(2,1,2)
%plot
semilogy(X,bac1_y, X, bac2_y);
%fancy stuff
xlabel('Time (minutes)');
%limit axis
axis([1,experiment_T,0,max_y]);
%plot intersection point
hold on
semilogy(intersectX,intersectY,'r*');
hold off





